/******************************************************************************
 *
 * Copyright (c) 1994-2003 PalmSource, Inc. All rights reserved.
 *
 * File: CatMgr.h
 *
 * Release: Palm OS 6.0
 *
 * Description:
 *		Header for the Category Manager
 *
 *****************************************************************************/

#ifndef _CATMGR_H_
#define _CATMGR_H_

// Include elementary types
#include <PalmTypes.h>					// Basic types
#include <DataMgr.h>

#include <Form.h>
#include <Control.h>
#include <List.h>


/////////////////////////////////////////////////////////////////////////////////////////////
// OS v40 style Category APIs and constants. These work only on record and resource databases
/////////////////////////////////////////////////////////////////////////////////////////////
// Note: although these constants are in the range of system resource IDs, the are actually
// constants passed to CategoryCreateList, CategorySelect, and CategoryFreeList which will
// produce the desired action.  The reason the constants are in this range is to keep them
// out of the numeric range that developers can use for resource IDs in the attempt to avoid
// conflicts.

#define categoryHideEditCategory				10000
#define categoryDefaultEditCategoryString		10001		


typedef struct AppInfoTag {
	uint16_t	renamedCategories;
	char	categoryLabels [dmRecNumCategories] [dmCategoryLength];
	uint8_t	categoryUniqIDs[dmRecNumCategories];
	uint8_t	lastUniqID;	// Uniq IDs generated by the device are between
						// 0 - 127.  Those from the PC are 128 - 255.
	uint8_t	padding;
} AppInfoType;

typedef AppInfoType *AppInfoPtr;


#ifdef __cplusplus
extern "C" {
#endif


//void CategoryCreateList (DmOpenRef db, ListType *listP,
//	uint16_t currentCategory, Boolean showAll,
//	Boolean showUneditables, uint8_t numUneditableCategories,
//	uint32_t editingStrID, Boolean resizeList);
extern void CategoryCreateList(
		DmOpenRef db,
		ListType * listP,
		uint16_t currentCategory,
		Boolean showAll,
		Boolean showUneditables,
		uint8_t numUneditableCategories,
		DmOpenRef	resDbRef,
		uint32_t editingStrID,
		Boolean resizeList);

extern void CategoryFreeList (DmOpenRef db, const ListType *listP,
	Boolean showAll, uint32_t editingStrID);

extern uint16_t CategoryFind (DmOpenRef db, const char *name);

extern void CategoryGetName (DmOpenRef db, uint16_t index, char *name);

//extern Boolean CategoryEdit (DmOpenRef db, uint16_t *category,
//	uint32_t titleStrID, uint8_t numUneditableCategories);
extern Boolean CategoryEdit(
			DmOpenRef db,
			uint16_t* categoryP,
			DmOpenRef	resDbRef,
			uint32_t titleStrID,
			uint8_t numUneditableCategories);

//extern Boolean CategorySelect (DmOpenRef db, const FormType *frm,
//	uint16_t ctlID, uint16_t lstID,	Boolean title, uint16_t *categoryP,
//	char *categoryName, uint8_t numUneditableCategories, uint32_t editingStrID);
extern Boolean CategorySelect(
			DmOpenRef db,
			const FormType * frm,
			uint16_t ctlID,
			uint16_t lstID,	
			Boolean title,
			uint16_t * categoryP,
			char * categoryName,
			uint8_t numUneditableCategories,
			DmOpenRef resDbRef,
			uint32_t editingStrID);

extern uint16_t CategoryGetNext (DmOpenRef db, uint16_t index);

extern void CategorySetTriggerLabel (ControlType *ctl, char *name);

extern void CategoryTruncateName (char *name, uint16_t maxWidth);

//extern void CategoryInitialize (AppInfoPtr appInfoP, uint16_t localizedAppInfoStrID);
extern void CategoryInitialize(AppInfoPtr appInfoP, DmOpenRef resDbRef, uint16_t localizedAppInfoStrID);

extern void CategorySetName (DmOpenRef db, uint16_t index, const char *nameP);



///////////////////////////////////////////////////////////////////////////////////
// New style (OS v6) CatMgr APIs and constants. These work only on schema databases
///////////////////////////////////////////////////////////////////////////////////
#define CategoryNameReserved				10021		

#define catNumCategories 					0xff						// for schema dbs only
#define catCategoryNameLength 				0x20						// for schema dbs only

#define catCategoryIDPositiveUpperBound		((CategoryID)0x7fffffff)	// for schema dbs only
#define catCategoryIDPositiveLowerBound		((CategoryID)0x00000010)	// for schema dbs only
#define catCategoryIDNegativeUpperBound		((CategoryID)0xfffffffe)	// for schema dbs only
#define catCategoryIDNegativeLowerBound		((CategoryID)0x80000001)	// for schema dbs only

#define catIDUnfiled						((CategoryID)0x00)			// for schema dbs only
#define catIDAll							((CategoryID)0x01)			// for schema dbs only
#define catIDMultiple						((CategoryID)0x02)			// for schema dbs only

// Error codes...
#define	catmErrMemError 					(catmErrorClass | 1)
#define	catmErrInvalidParam					(catmErrorClass | 2)
#define	catmErrCantFind						(catmErrorClass | 3)
#define	catmErrIndexOutOfRange				(catmErrorClass | 4)
#define	catmErrCategoryNotFound 			(catmErrorClass | 5)
#define catmErrNameAlreadyExists 			(catmErrorClass | 6)
#define catmErrInvalidStoragePtr 			(catmErrorClass | 7)
#define catmErrMaxCategoryLimit 			(catmErrorClass | 8)
#define catmErrAISResourceNotFound 			(catmErrorClass | 9)
#define catmErrNotSchemaDatabase			(catmErrorClass | 10)
#define catmErrReadOnlyDatabase				(catmErrorClass | 11)


// Category management routines
status_t CatMgrAdd(DmOpenRef dbP, const char *nameP, CategoryID *catIDP);

status_t CatMgrRemove(DmOpenRef dbP, CategoryID catID);

status_t CatMgrGetName(DmOpenRef dbP, CategoryID catID, char *nameP);

status_t CatMgrGetUnfiledItemLabel(DmOpenRef dbP, char *labelP);

status_t CatMgrGetAllItemLabel(DmOpenRef dbP, char *labelP);

status_t CatMgrSetName(DmOpenRef dbP, CategoryID catID, const char *nameP);

status_t CatMgrGetEditable(DmOpenRef dbP, CategoryID catID, Boolean* editableP);

status_t CatMgrSetEditable(DmOpenRef dbP, CategoryID catID, Boolean editable);

status_t CatMgrFind(DmOpenRef dbP, const char *nameP, CategoryID *catIDP);

status_t CatMgrNumCategories(DmOpenRef dbP, uint32_t* numCategoriesP);

status_t CatMgrGetID(DmOpenRef dbP, uint32_t index, CategoryID *catIDP);

status_t CatMgrGetNext(DmOpenRef dbP, CategoryID inCatID, CategoryID* outCatIDP);


//Category UI routines
//status_t CatMgrInitialize(DmOpenRef dbRef, DmOpenRef resDbRef, uint16_t localizedCategoryNamesStrID);
status_t CatMgrInitialize(DmOpenRef dbRef, MemHandle localizedCategoryNamesStrH);

//Boolean CatMgrSelectFilter(DmOpenRef		dbRef,
//						   const FormType*	frm,
//						   uint16_t			ctlID,
//						   char*			ctlLabelBuffer,
//						   uint16_t			lstID,
//						   CategoryID*		categoryP,
//						   Boolean			showEditingStr,
//						   char*			customEditingStrP);
Boolean CatMgrSelectFilter(DmOpenRef		dbRef,
						   const FormType*	frm,
						   uint16_t			ctlID,
						   char*			ctlLabelBuffer,
						   uint16_t			lstID,
						   CategoryID*		inCurrentCategoriesP,
						   uint32_t			numInCurrentCategories,
						   CategoryID**		outCurrentCategoriesPP,
						   uint32_t*			numOutCurrentCategoriesP,
						   Boolean			showEditingStr,
						   char*			customEditingStrP);

Boolean CatMgrSelectEdit(DmOpenRef			dbRef,
						 const FormType*	frm,
						 uint16_t				ctlID,
						 char*				ctlLabelBuffer,
						 uint16_t				lstID,
						 Boolean			allowMultiple,
						 CategoryID			currentCategoriesP[],
						 uint32_t				numCurrentCategories,
						 CategoryID*		selectedCategoriesPP[],
						 uint32_t*			numSelectedCategoriesP,
						 Boolean			showEditingStr,
						 char*				customEditingStrP);

status_t CatMgrCreateList(DmOpenRef		dbRef,
					 ListType*		listP,
					 CategoryID		currentCategory,
					 Boolean		showAll,
					 Boolean		showMultiple,
					 Boolean		showUneditables,
					 Boolean		resizeList,
					 Boolean		showEditingStr,
					 char*			customEditingStrP);

//Boolean CatMgrEdit(DmOpenRef dbRef,
//				   CategoryID* categoryP,
//				   char* titleStrP);
Boolean CatMgrEdit(DmOpenRef dbRef,
				   CategoryID* inCurrentCategoriesP,
				   uint32_t numInCurrentCategories,
				   CategoryID** outCurrentCategoriesPP,
				   uint32_t* numOutCurrentCategoriesP,
				   char* titleStrP);

void CatMgrFreeList(DmOpenRef dbRef,
					ListType * listP,
					Boolean showAll,
					Boolean showMultiple,
					Boolean showEditingStr);

void CatMgrTruncateName(DmOpenRef dbRef,
						CategoryID categoriesP[],
						uint32_t numCategories,
						uint16_t maxWidth,
						char* nameP);

void CatMgrSetTriggerLabel(DmOpenRef dbRef,
						   CategoryID categoriesP[],
						   uint32_t numCategories,
						   ControlType * ctl,
						   char* nameP);

void CatMgrFreeSelectedCategories(DmOpenRef dbRef, CategoryID**	selectedCategoriesPP);

#ifdef __cplusplus
}
#endif


#endif
